/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: CifXDeviceSys.h 12750 2019-03-01 10:16:35Z LuisContreras $:

  Description:
    System device class, derived from CCifXDeviceBase to handle a system channel connection

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2011-12-08  Added extended memory dialog (MRAM)
    2010-04-29  Updated to latest cifXUser / stdint.h
    2006-06-28  initial version

**************************************************************************************/

#pragma once

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifXDeviceSys.h
///   System device class, derived from CCifXDeviceBase to handle a system channel connection
///////////////////////////////////////////////////////////////////////////////////////////

#include "cifxdevicebase.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// System device class
///////////////////////////////////////////////////////////////////////////////////////////
class CCifXDeviceSys : public CCifXDeviceBase
{
public:
  CCifXDeviceSys(BOARD_INFORMATION* ptBoardInfo, CHANNEL_INFORMATION* ptChannelInfo);
  virtual ~CCifXDeviceSys(void);

  virtual bool                             IsSystemDevice(void);
  virtual int32_t                          OpenDevice(void);
  virtual int32_t                          CloseDevice(void);
  virtual int32_t                          PutPacket(CIFX_PACKET* ptPacket, uint32_t ulTimeout);
  virtual int32_t                          GetPacket(CIFX_PACKET* ptPacket, uint32_t ulBufferSize, uint32_t ulTimeout);
  virtual CCifXDeviceBase::PROPERTY_VECTOR GetChannelInformation(uint32_t ulCmd);
  virtual CString                          GetChannelInfoName(void);
  virtual int32_t                          GetMBXState(uint32_t* pulRecvCount, uint32_t* pulSendCount);
  virtual int32_t                          Reset(uint32_t ulMode, uint32_t ulTimeout, uint32_t ulResetParam);
  virtual int32_t                          Upload(char* szFilename, uint32_t ulChannel, unsigned char* pbBuffer, uint32_t* pulFileSize);
  
  virtual int32_t Download(uint32_t ulChannel, uint32_t ulMode, char* szFileName, 
                        unsigned char* pabFileData, uint32_t ulFileSize, 
                        PFN_PROGRESS_CALLBACK pfnCallback, void* pvUser);

  virtual int32_t FindFirstFile(uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo);
  virtual int32_t FindNextFile(uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo);

  virtual int32_t ExtendedMemoryMap(void);
  virtual int32_t ExtendedMemoryRelease(void);
  virtual int32_t ExtendedMemoryInfo(uint32_t& ulSize, uint32_t& ulType);
  virtual void*   ExtendedMemoryPointer(uint32_t* pulExtMemSize);

/////////////////////////////////////////////////////////////////////////////
  /// Overridden function for channel number. The System device does not own one, so return 0
  ///   \return 0
  /////////////////////////////////////////////////////////////////////////////
  virtual uint32_t GetChannelNr(void) { return 0; }
  virtual uint32_t GetMailboxSize(void);

protected:
  HANDLE m_hSysChannel;   //!< cifX driver Handle to the system channel

  CIFX_EXTENDED_MEMORY_INFORMATION  m_tMappedExtMem;

  int32_t GetSystemInfoBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemInformation(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemChannelBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemControlBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemStatusBlock(PROPERTY_VECTOR& cvRet);

};
